/*
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE":
 * I wrote this file. As long as you retain this notice you can do
 * whatever you want with this stuff. If we meet some day, and you think
 * this stuff is worth it, you can buy me a beer in return - Sebastian Roll
 * ----------------------------------------------------------------------------
 */

using System;
using System.Collections;
using System.IO;

namespace FileSystemWatch
{
    /// <summary>
    /// Abstracts an Array of Strings.
    /// Can load/save Array from/to file.
    /// Can compare if a given String is inside the Array.
    /// </summary>
    public class PathContainer
    {
        // the strings
        public ArrayList paths = new ArrayList();

        // fills array with string-lines from given file
        public void load(String fileName)
        {
            String line = "";

            try
            {
                // open given file
                using (StreamReader sr = new StreamReader(fileName))
                {
                    // end of file reached?
                    while (sr.Peek() >= 0)
                    {
                        // no, read next line
                        line = sr.ReadLine();
                        // input is a valid string?
                        if (line.Trim().Length > 0)
                        {
                            // append string to string array
                            paths.Add(line);
                        }
                    }
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine("*** " + exp.Message + " ***");
            }
        }

        // stores string-lines from array to file
        public void safe(String fileName)
        {
            String line = "";

            try
            {
                // open given file
                using (StreamWriter sw = new StreamWriter(fileName))
                {
                    // iterate all strings in array
                    foreach (String s in paths)
                    {
                        // append string-line to file
                        line = s;
                        sw.WriteLine(s);
                    }
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine("*** " + exp.Message + " ***");
            }
        }

        // empty the string array
        public void clear()
        {
            paths.Clear();
        }

        // append given string to array
        public void add(String s)
        {
            paths.Add(s);
        }

        // returns true if given string is inside string-array
        // ignores case, blanks and path-delimiters
        public bool containsIgnoreCase(String s)
        {
            char[] trimChars = { '\\', ' ' };

            // iterate all strings in array
            foreach (String p in paths)
            {
                // given string and itarator string is valid?
                if (s != null && p != null)
                {
                    // yes, remove unnecessary chars
                    String s1 = s.Trim(trimChars).ToLower();
                    String p1 = p.Trim(trimChars).ToLower();

                    // compare both strings
                    if (s1.Contains(p1))
                    {
                        return true;
                    }
                }
            }

            // given string not found
            return false;
        }
    }
}
