/*
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE":
 * I wrote this file. As long as you retain this notice you can do
 * whatever you want with this stuff. If we meet some day, and you think
 * this stuff is worth it, you can buy me a beer in return - Sebastian Roll
 * ----------------------------------------------------------------------------
 */

using System;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;
using System.Drawing;

namespace FileSystemWatch
{
   /// <summary>
   /// Window with many checkBoxes, radioButtons and a textEditBox.
   /// Can load its state from file.
   /// Can write its state to file.
   /// All options are exposed to public by get/set
   /// </summary>
   public partial class OptionsWindow : Form
   {
      // default state in case no config file was found
      // below members are re-set on load() function
      private bool useFileFilter = false;
      private String fileFilterList = "doc, xls, ppt, pps, mpp, pdf, txt, rtf, zip, rar, msg, bmp, jpg, tif, gif, png, c, cpp, h, exe";
      private bool notifyOnFileChange = true;
      private bool notifyOnFileCreate = true;
      private bool notifyOnFileDelete = true;
      private bool notifyOnFileRename = true;
      private bool notifyOnFolderChange = true;
      private bool showBaloonTips = true;
      private bool minimizeToTrayOnCloseWindow = false;
      private bool logToFile = false;
      private bool debugToFile = false;
      private bool autoScrollDataGrid = true;
      private bool msOfficeDiscardAutoSave = false;
      private bool msOfficeDiscardTempFiles = false;
      private Point mainWindowLocation = new Point();
      private Size mainWindowSize = new Size();

      // ctor
      public OptionsWindow()
      {
         InitializeComponent();
      }

      // expose all members to public
      public bool UseFileFilter
      {
         get { return useFileFilter; }
         set { useFileFilter = value; }
      }

      public String FileFilterList
      {
         get { return fileFilterList; }
         set { fileFilterList = value; }
      }

      public bool NotifyOnFileCreate
      {
         get { return notifyOnFileCreate; }
         set { notifyOnFileCreate = value; }
      }

      public bool NotifyOnFileChange
      {
         get { return notifyOnFileChange; }
         set { notifyOnFileChange = value; }
      }

      public bool NotifyOnFileDelete
      {
         get { return notifyOnFileDelete; }
         set { notifyOnFileDelete = value; }
      }

      public bool NotifyOnFileRename
      {
         get { return notifyOnFileRename; }
         set { notifyOnFileRename = value; }
      }

      public bool NotifyOnFolderChange
      {
         get { return notifyOnFolderChange; }
         set { notifyOnFolderChange = value; }
      }

      public bool ShowBaloonTips
      {
         get { return showBaloonTips; }
         set { showBaloonTips = value; }
      }

      public bool MinimizeToTrayOnCloseWindow
      {
         get { return minimizeToTrayOnCloseWindow; }
         set { minimizeToTrayOnCloseWindow = value; }
      }

      public bool LogToFile
      {
         get { return logToFile; }
         set { logToFile = value; }
      }

      public bool DebugToFile
      {
         get { return debugToFile; }
         set { debugToFile = value; }
      }

      public bool AutoScrollDataGrid
      {
         get { return autoScrollDataGrid; }
         set { autoScrollDataGrid = value; }
      }

      public bool MsOfficeDiscardAutoSave
      {
         get { return msOfficeDiscardAutoSave; }
         set { msOfficeDiscardAutoSave = value; }
      }

      public bool MsOfficeDiscardTempFiles
      {
         get { return msOfficeDiscardTempFiles; }
         set { msOfficeDiscardTempFiles = value; }
      }

      public Point MainWindowLocation
      {
         get { return mainWindowLocation; }
         set { mainWindowLocation = value; }
      }

      public Size MainWindowSize
      {
         get { return mainWindowSize; }
         set { mainWindowSize = value; }
      }

      // load window state from file
      public void load(String fileName)
      {
         String line = "";

         try
         {
            // open given file
            using (StreamReader sr = new StreamReader(fileName))
            {
               // read state from given file
               line = sr.ReadLine();
               useFileFilter = (line == "useFileFilter=1");
               line = sr.ReadLine();
               fileFilterList = line;
               line = sr.ReadLine();
               notifyOnFileCreate = (line == "notifyOnFileCreate=1");
               line = sr.ReadLine();
               notifyOnFileChange = (line == "notifyOnFileChange=1");
               line = sr.ReadLine();
               notifyOnFileDelete = (line == "notifyOnFileDelete=1");
               line = sr.ReadLine();
               notifyOnFileRename = (line == "notifyOnFileRename=1");
               line = sr.ReadLine();
               notifyOnFolderChange = (line == "notifyOnFolderChange=1");
               line = sr.ReadLine();
               showBaloonTips = (line == "showBaloonTips=1");
               line = sr.ReadLine();
               minimizeToTrayOnCloseWindow = (line == "minimizeToTrayOnCloseWindow=1");
               line = sr.ReadLine();
               logToFile = (line == "logToFile=1");
               line = sr.ReadLine();
               debugToFile = (line == "debugToFile=1");
               line = sr.ReadLine();
               autoScrollDataGrid = (line == "autoScrollDataGrid=1");
               line = sr.ReadLine();
               msOfficeDiscardAutoSave = (line == "msOfficeDiscardAutoSave=1");
               line = sr.ReadLine();
               msOfficeDiscardTempFiles = (line == "msOfficeDiscardTempFiles=1");
               line = sr.ReadLine();
               mainWindowLocation.X = Convert.ToInt32(line);
               line = sr.ReadLine();
               mainWindowLocation.Y = Convert.ToInt32(line);
               line = sr.ReadLine();
               mainWindowSize.Width = Convert.ToInt32(line);
               line = sr.ReadLine();
               mainWindowSize.Height = Convert.ToInt32(line);
            }
         }
         catch (Exception exp)
         {
            Console.WriteLine("*** " + exp.Message + " ***");
         }
      }

      // store window state to file
      public void safe(String fileName)
      {
         String line = "";

         try
         {
            // open given file
            using (StreamWriter sw = new StreamWriter(fileName))
            {
               // write current state to given file
               line = (useFileFilter == true) ? "useFileFilter=1" : "useFileFilter=0";
               sw.WriteLine(line);
               sw.WriteLine(fileFilterList);
               line = (notifyOnFileCreate == true) ? "notifyOnFileCreate=1" : "notifyOnFileCreate=0";
               sw.WriteLine(line);
               line = (notifyOnFileChange == true) ? "notifyOnFileChange=1" : "notifyOnFileChange=0";
               sw.WriteLine(line);
               line = (notifyOnFileDelete == true) ? "notifyOnFileDelete=1" : "notifyOnFileDelete=0";
               sw.WriteLine(line);
               line = (notifyOnFileRename == true) ? "notifyOnFileRename=1" : "notifyOnFileRename=0";
               sw.WriteLine(line);
               line = (notifyOnFolderChange == true) ? "notifyOnFolderChange=1" : "notifyOnFolderChange=0";
               sw.WriteLine(line);
               line = (showBaloonTips == true) ? "showBaloonTips=1" : "showBaloonTips=0";
               sw.WriteLine(line);
               line = (minimizeToTrayOnCloseWindow == true) ? "minimizeToTrayOnCloseWindow=1" : "minimizeToTrayOnCloseWindow=0";
               sw.WriteLine(line);
               line = (logToFile == true) ? "logToFile=1" : "logToFile=0";
               sw.WriteLine(line);
               line = (debugToFile == true) ? "debugToFile=1" : "debugToFile=0";
               sw.WriteLine(line);
               line = (autoScrollDataGrid == true) ? "autoScrollDataGrid=1" : "autoScrollDataGrid=0";
               sw.WriteLine(line);
               line = (msOfficeDiscardAutoSave == true) ? "msOfficeDiscardAutoSave=1" : "msOfficeDiscardAutoSave=0";
               sw.WriteLine(line);
               line = (msOfficeDiscardTempFiles == true) ? "msOfficeDiscardTempFiles=1" : "msOfficeDiscardTempFiles=0";
               sw.WriteLine(line);
               line = Convert.ToString(mainWindowLocation.X);
               sw.WriteLine(line);
               line = Convert.ToString(mainWindowLocation.Y);
               sw.WriteLine(line);
               line = Convert.ToString(mainWindowSize.Width);
               sw.WriteLine(line);
               line = Convert.ToString(mainWindowSize.Height);
               sw.WriteLine(line);
            }
         }
         catch (Exception exp)
         {
            Console.WriteLine("*** " + exp.Message + " ***");
         }
      }

      // on window show: update all controls and set some toolTips
      private void OptionsWindow_Load(object sender, EventArgs e)
      {
         radioButton1.Checked = useFileFilter;
         radioButton2.Checked = !useFileFilter;
         textBox1.Text = fileFilterList;
         checkBox1.Checked = notifyOnFileChange;
         checkBox2.Checked = notifyOnFileCreate;
         checkBox3.Checked = notifyOnFileDelete;
         checkBox4.Checked = notifyOnFileRename;
         checkBox9.Checked = notifyOnFolderChange;
         checkBox5.Checked = showBaloonTips;
         checkBox6.Checked = minimizeToTrayOnCloseWindow;
         checkBox7.Checked = logToFile;
         checkBox12.Checked = debugToFile;
         checkBox8.Checked = autoScrollDataGrid;
         checkBox10.Checked = msOfficeDiscardAutoSave;
         checkBox11.Checked = msOfficeDiscardTempFiles;
         toolTip1.SetToolTip(textBox1, "Enter file extensions separated by comma\r\n(e.g. doc, txt, ...)");
         toolTip1.SetToolTip(radioButton1, "Enter file extensions separated by comma\r\n(e.g. doc, txt, ...)");
         toolTip1.SetToolTip(radioButton2, "Get notifications on every file activity\r\n(below options will be still applied)");
         toolTip1.SetToolTip(checkBox1, "Notify if a file was changed");
         toolTip1.SetToolTip(checkBox2, "Notify if a file was created");
         toolTip1.SetToolTip(checkBox3, "Notify if a file was deleted");
         toolTip1.SetToolTip(checkBox4, "Notify if a file was renamed");
         toolTip1.SetToolTip(checkBox9, "Notify if the name of a folder was changed");
         toolTip1.SetToolTip(checkBox5, "Pop up a tiny message on file activity");
         toolTip1.SetToolTip(checkBox6, "Main window will not close if 'x' button was clicked\r\n(but you can exit anytime by using the context menu)");
         toolTip1.SetToolTip(checkBox7, "Write all notifications to file\r\n(LogFile will be created in FileSystemWatch folder with an unique filename)");
         toolTip1.SetToolTip(checkBox12, "Write also program internal messages to LogFile");
         toolTip1.SetToolTip(checkBox8, "Main window will always show the\r\nvery last notification at bottom");
         toolTip1.SetToolTip(checkBox10, "Do not notify if Microsoft Office\r\nprograms do automatic backup file access");
         toolTip1.SetToolTip(checkBox11, "Do not notify if Microsoft Office\r\nprograms do temporary file access");
      }

      // on window close: store window state to file
      private void OptionsWindow_FormClosed(object sender, FormClosedEventArgs e)
      {
         safe("FSWConfig.txt");
      }

      // event-handlers for all controls -> update private members on user change
      private void radioButton1_CheckedChanged(object sender, EventArgs e)
      {
         useFileFilter = radioButton1.Checked;
      }

      private void textBox1_TextChanged(object sender, EventArgs e)
      {
         fileFilterList = textBox1.Text;
      }

      private void checkBox1_CheckedChanged(object sender, EventArgs e)
      {
         notifyOnFileChange = checkBox1.Checked;
      }

      private void checkBox2_CheckedChanged(object sender, EventArgs e)
      {
         notifyOnFileCreate = checkBox2.Checked;
      }

      private void checkBox3_CheckedChanged(object sender, EventArgs e)
      {
         notifyOnFileDelete = checkBox3.Checked;
      }

      private void checkBox4_CheckedChanged(object sender, EventArgs e)
      {
         notifyOnFileRename = checkBox4.Checked;
      }

      private void checkBox5_CheckedChanged(object sender, EventArgs e)
      {
         showBaloonTips = checkBox5.Checked;
      }

      private void checkBox6_CheckedChanged(object sender, EventArgs e)
      {
         minimizeToTrayOnCloseWindow = checkBox6.Checked;
      }

      private void checkBox7_CheckedChanged(object sender, EventArgs e)
      {
         logToFile = checkBox7.Checked;
      }

      private void checkBox8_CheckedChanged(object sender, EventArgs e)
      {
         autoScrollDataGrid = checkBox8.Checked;
      }

      private void checkBox9_CheckedChanged(object sender, EventArgs e)
      {
         notifyOnFolderChange = checkBox9.Checked;
      }

      private void checkBox10_CheckedChanged(object sender, EventArgs e)
      {
         msOfficeDiscardAutoSave = checkBox10.Checked;
      }

      private void checkBox11_CheckedChanged(object sender, EventArgs e)
      {
         msOfficeDiscardTempFiles = checkBox11.Checked;
      }

      private void checkBox12_CheckedChanged(object sender, EventArgs e)
      {
         debugToFile = checkBox12.Checked;
      }
   }
}