/*
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE":
 * I wrote this file. As long as you retain this notice you can do
 * whatever you want with this stuff. If we meet some day, and you think
 * this stuff is worth it, you can buy me a beer in return - Sebastian Roll
 * ----------------------------------------------------------------------------
 */

using System;
using System.Collections.Generic;
using System.Windows.Forms;

namespace FileSystemWatch
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            // only one single instance of this app is allowed on the user's machine at any time
            // create a mutex, visible to all processes on this machine
            System.Threading.Mutex instanceLock = new System.Threading.Mutex(false, "FileSystemWatch");

            // check if the mutex was aquired beforehand
            if (instanceLock.WaitOne(0, false))
            {
                // no, go ahead and start the app
                try
                {
                    Application.EnableVisualStyles();
                    Application.SetCompatibleTextRenderingDefault(false);
                    Application.Run(new MainWindow());
                }
                finally
                {
                    instanceLock.ReleaseMutex();
                }
            }
            else
            {
                MessageBox.Show("You cannot have two instances of this application running", "FileSystemWatch");
                Application.Exit();
            }
        }
    }
}